#!/bin/bash
echo [INFO]"=============Begin to start Workspace================="
echo [INFO]"who am i?"
whoami

export QT_QPA_PLATFORM=xcb

QTDIR=/userdata/H3C/Workspace/RUN/qt/desktop

COMPATIBLE=$(cat /proc/device-tree/compatible)
IS_3568="$(echo $COMPATIBLE |grep rk3568)"
if [ -n "$IS_3568" ]; then
    echo device is 3568
    QTDIR=/userdata/H3C/Workspace/RUN/qt/opengles
fi

DEVICE_NAME=$(cat /sys/devices/virtual/dmi/id/product_name)
IS_CE520F="$(echo $DEVICE_NAME |grep CE520F)"
if [ -n "$IS_CE520F" ]; then
    echo device is inspur CE520F
    QTDIR=/userdata/H3C/Workspace/RUN/qt/opengles
fi

export LD_LIBRARY_PATH=/userdata/H3C/Workspace/RUN:${QTDIR}:"$LD_LIBRARY_PATH"
export LD_LIBRARY_PATH=/userdata/H3C/Workspace/RUN/gstreamer-1.0:"$LD_LIBRARY_PATH"
export LD_LIBRARY_PATH=/userdata/H3C/Workspace/RUN/quic:"$LD_LIBRARY_PATH"
export LD_LIBRARY_PATH=/userdata/H3C/Workspace/RUN/"Device Redirect":"$LD_LIBRARY_PATH"
export QTWEBENGINE_CHROMIUM_FLAGS="--no-sandbox VdSession"
export QT_PLUGIN_PATH=${QTDIR}/plugins:${QTDIR}:$QT_PLUGIN_PATH
export QML2_IMPORT_PATH=${QTDIR}:$QT_PLUGIN_PATH
export GST_PLUGIN_PATH=/userdata/H3C/Workspace/RUN/gstreamer-1.0:$GST_PLUGIN_PATH
export GST_PLUGIN_SCANNER=/userdata/H3C/Workspace/RUN/gstreamer-1.0/gst-plugin-scanner

#linux多用户下，DISPLAY 未必是0:.0
#export DISPLAY=:0.0
export QT_LOGGING_RULES=
echo [INFO] The value of DISPLAY is:
echo [INFO] $DISPLAY

/userdata/H3C/Workspace/RUN/Workspace $1 &

