#! /bin/bash
echo "[INFO] $(date) Start to install Workspace" | tee /userdata/installws.log

INSTALL_MODE=$1

# current path of this script
current=$(cd "$(dirname "$0")"; pwd)

# 生成INFO文件, 保存COMMON路径 给Upgrader关于COMMON_DIR的信息, 生成完成后, 一定要记得退出
# 注意, 这个单独功能放在最前面
if [ "${INSTALL_MODE}" == "-m" ]; then
cat >"${current}/INFO"<<EOF
/userdata/H3C/Workspace
/userdata/H3C/Workspace/RUN
workspace-vdi
Workspace
884506624 bytes
EOF
exit 0
fi

#如果当前系统安装了老版本workspace，则删除
tlist=$(dpkg -l --admindir=/userdata/var/lib/dpkg | grep -iE 'workspace-e10|workspace-vdi' | awk '{print $2}')
set -- ${tlist}
while [ -n "${1}" ]; do
    echo "dpkg -r --admindir=/userdata/var/lib/dpkg ${1}" | tee -a /userdata/installws.log
    dpkg -r --admindir=/userdata/var/lib/dpkg ${1}

    echo "dpkg -P --force-remove-reinstreq --admindir=/userdata/var/lib/dpkg ${1}"  | tee -a /userdata/installws.log
    dpkg -P --force-remove-reinstreq --admindir=/userdata/var/lib/dpkg ${1}
    shift
done

tlist=$(dpkg -l | grep -iE 'workspace-e10|workspace-vdi' | awk '{print $2}')
set -- ${tlist}
while [ -n "${1}" ]; do
    echo "dpkg -r ${1}"  | tee -a /userdata/installws.log
    dpkg -r ${1}

    echo "dpkg -P --force-remove-reinstreq ${1}"  | tee -a /userdata/installws.log
    dpkg -P --force-remove-reinstreq ${1}
    shift
done

function check_spaceagent {
    SPACE_AGENT_INSTALLED=$(dpkg --admindir=/userdata/var/lib/dpkg -s spaceagent)
    SPACE_AGENT_INSTALLEDOK=$(dpkg --admindir=/userdata/var/lib/dpkg -s spaceagent | grep 'install ok installed')

    if [ "$SPACE_AGENT_INSTALLED" != "" ]
    then
        echo "spaceagent is installed in /userdata"  | tee -a /userdata/installws.log
        if [ "$SPACE_AGENT_INSTALLEDOK" == "" ]
        then
            echo "spaceagent is not installed ok in /userdata, going to remove"  | tee -a /userdata/installws.log
            SPACE_AGENT_INSTALLED=""
            SPACE_AGENT_INSTALLEDOK=""
            dpkg --admindir=/userdata/var/lib/dpkg -r --force-remove-reinstreq spaceagent
            dpkg --admindir=/userdata/var/lib/dpkg -P --force-remove-reinstreq spaceagent
        fi
    else
        echo "spaceagent is NOT installed in /userdata"  | tee -a /userdata/installws.log
        SPACE_AGENT_INSTALLED=$(dpkg -s spaceagent)
        SPACE_AGENT_INSTALLEDOK=$(dpkg -s spaceagent | grep 'install ok installed')
        if [ "$SPACE_AGENT_INSTALLED" != "" ]
        then
            echo "spaceagent is installed in system"  | tee -a /userdata/installws.log
            if [ "$SPACE_AGENT_INSTALLEDOK" == "" ]
                then
                    echo "spaceagent is not installed ok in system, going to remove"  | tee -a /userdata/installws.log
                    SPACE_AGENT_INSTALLED=""
                    SPACE_AGENT_INSTALLEDOK=""
                    dpkg -r --force-remove-reinstreq spaceagent
                    dpkg -P --force-remove-reinstreq spaceagent
            fi
        else
            echo "spaceagent is NOT installed in system"  | tee -a /userdata/installws.log
        fi 
    fi

    if [ "$SPACE_AGENT_INSTALLEDOK" == "" ]
    then
        # 如果当前系统没有安装spaceagent，则先安装spaceagent
        if [[ -f /etc/spaceos-version ]]; then
            echo "spaceos, install spaceagent deb pkg info into /userdata/var/lib/dpkg"  | tee -a /userdata/installws.log
            dpkg -i  --admindir=/userdata/var/lib/dpkg "$current/H3C_Workspace_SpaceAgent-E1016P02-linux-aarch64.deb" 2>&1 | tee -a /userdata/installws.log
        else
            echo "NOT spaceos, install spaceagent deb pkg info into system"  | tee -a /userdata/installws.log
            dpkg -i  "$current/H3C_Workspace_SpaceAgent-E1016P02-linux-aarch64.deb" 2>&1 | tee -a /userdata/installws.log
        fi
    fi
}

# ------------------------
# 安装客户端定制文件
# ------------------------
function doInstallImage {
    if [ -d "${current}/Image" ]; then
        echo "deploy custom files into /userdata/H3C/Workspace/RUN/Image"  | tee -a /userdata/installws.log
        cp -rf "${current}/Image" /userdata/H3C/Workspace/RUN/Image
    fi
}
# --------------------------
# install debian package
# -------------------------
function doInstall {
    rm -f /userdata/installwserror
   
    devnode=$(stat -c %m /userdata/)
    freesize=$(df $devnode -B1 | grep / | grep -v Available | grep -v "可用" | awk '{print $4}')
    #额外预留10M=10485760
    let sizeneed=$InstalledSizeB+10485760
    if [ $sizeneed -gt $freesize ]
    then
        echo "ERROR: Insufficient disk space, freesize on /userdata is $freesize, size needed is $sizeneed" | tee -a /userdata/installws.log
        echo "ERROR: failed to install workspace-vdi, Insufficient disk space" >> /userdata/installwserror
        echo "free size: $freesize" >> /userdata/installwserror
        echo "size needed: $sizeneed" >> /userdata/installwserror

        exit 1
    fi

    if [[ -f /etc/spaceos-version ]]; then
        echo "spaceos, install workspace deb pkg info into /userdata/var/lib/dpkg"  | tee -a /userdata/installws.log

        # 安装之前生成一些目录或文件, dpkg会使用这个目录
        if [ ! -d "/userdata/var/lib/dpkg" ]; then
            mkdir -p /userdata/var/lib/dpkg
        fi

        if [ ! -d "/userdata/var/lib/dpkg/updates" ]; then
            mkdir -p /userdata/var/lib/dpkg/updates
        fi

        if [ ! -d "/userdata/var/lib/dpkg/info" ]; then
            mkdir -p /userdata/var/lib/dpkg/info
        fi

        if [ ! -f "/userdata/var/lib/dpkg/status" ]; then
            touch /userdata/var/lib/dpkg/status
        fi


        dpkg -i  --admindir=/userdata/var/lib/dpkg  "$current/H3C_Workspace_App-E1016P02-linux-aarch64.deb" 2>&1 | tee -a /userdata/installws.log

        ##check
	installok=$(dpkg --admindir=/userdata/var/lib/dpkg -s workspace-vdi  | grep -i "install ok installed")
        if [ "$installok" = "" ]
        then
            echo "ERROR: failed to install workspace-vdi, please contact the administrator"  | tee -a /userdata/installws.log 
            echo "ERROR: failed to install workspace-vdi, please contact the administrator" > /userdata/installwserror

            echo "dpkg -r --admindir=/userdata/var/lib/dpkg workspace-vdi"   | tee -a /userdata/installws.log
            dpkg -r --admindir=/userdata/var/lib/dpkg workspace-vdi
            
            echo "dpkg -P --force-remove-reinstreq --admindir=/userdata/var/lib/dpkg workspace-vdi"   | tee -a /userdata/installws.log
            dpkg -P --force-remove-reinstreq --admindir=/userdata/var/lib/dpkg workspace-vdi

            exit 1
        fi

        doInstallImage
    else
        echo "NOT spaceos, install workspace deb pkg info into system"  | tee -a /userdata/installws.log
        dpkg -i "$current/H3C_Workspace_App-E1016P02-linux-aarch64.deb" 2>&1 | tee -a /userdata/installws.log
        ##check
	installok=$(dpkg -s workspace-vdi | grep -i "install ok installed")
        if [ "$installok" = "" ]
        then
            echo "ERROR: failed to install workspace-vdi, please contact the administrator" | tee -a /userdata/installws.log
            echo "ERROR: failed to install workspace-vdi, please contact the administrator" > /userdata/installwserror

            echo "dpkg -r workspace-vdi" | tee -a /userdata/installws.log
            dpkg -r workspace-vdi

            echo "dpkg -P --force-remove-reinstreq workspace-vdi" | tee -a /userdata/installws.log
            dpkg -P --force-remove-reinstreq workspace-vdi

            exit 1
        fi

        doInstallImage
    fi
}

doInstall
check_spaceagent

