#ifdef GL_ES 
#ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#else
precision mediump float;
#endif
#endif
varying vec2 texc;
uniform sampler2D tex_y;
uniform sampler2D tex_u;
uniform sampler2D tex_v;
uniform sampler2D texturergb;
uniform int streamMode;
uniform int flag;
varying vec4 outStreamRect[4];
void main()
{
	if(streamMode==2)
	{
		gl_FragColor = vec4(texture2D(texturergb, texc).bgr,1);
	}
	else
	{
		vec3 yuv;
		vec3 rgb;
		if(flag==1)//yuv420  yuv444
		{
			yuv.x = texture2D(tex_y, texc).r - 0.0625;
			yuv.y = texture2D(tex_u, texc).r - 0.5;
			yuv.z = texture2D(tex_v, texc).r - 0.5;
		}   
		else if(flag==2)
		{
			yuv.x = texture2D(tex_y, texc).r - 0.0625;
			yuv.y = texture2D(tex_u, texc).r - 0.5;
			yuv.z = texture2D(tex_v, texc).g - 0.5;
		}
		rgb = mat3( 1.164,1.164,1.164,0,-0.391,2.018,1.596, -0.813,0) * yuv;
		if((gl_FragCoord.x >= outStreamRect[0].x && gl_FragCoord.x <= outStreamRect[0].y && gl_FragCoord.y >= outStreamRect[0].z && gl_FragCoord.y <= outStreamRect[0].w) || 		 (gl_FragCoord.x >= outStreamRect[1].x && gl_FragCoord.x <= outStreamRect[1].y && gl_FragCoord.y >= outStreamRect[1].z && gl_FragCoord.y <= outStreamRect[1].w) ||
		(gl_FragCoord.x >= outStreamRect[2].x && gl_FragCoord.x <= outStreamRect[2].y && gl_FragCoord.y >= outStreamRect[2].z && gl_FragCoord.y <= outStreamRect[2].w) ||
		(gl_FragCoord.x >= outStreamRect[3].x && gl_FragCoord.x <= outStreamRect[3].y && gl_FragCoord.y >= outStreamRect[3].z && gl_FragCoord.y <= outStreamRect[3].w))
		{
			gl_FragColor = vec4(rgb, 1);
		}
		else
		{
			gl_FragColor = vec4(texture2D(texturergb, texc).bgr,1);
		}
	}
}