#!/bin/bash

LANGUAGE="en_US"

app_name="chromium-browser"
app_pid=$1
action=$2
param=$3

current_sink_num=''
sink_num_check=''
app_name_check=''
current_name=''
sink_pid_check=''

pactl list sink-inputs | while read line; 
do 
	sink_num_check=$(echo "$line" |sed -rn 's/^Sink Input #(.*)/\1/p')
    if [ "$sink_num_check" != "" ]; then
        current_sink_num="$sink_num_check"
    else
        app_name_check=$(echo "$line" | sed -rn 's/application.icon_name = "([^"]*)"/\1/p')
	sink_pid_check=$(echo "$line" | sed -rn 's/application.process.id = "([^"]*)"/\1/p')	
	if [ "$app_name_check" != "" ]; then
	    current_name="$app_name_check"
	fi	
	if [ "$current_name" = "$app_name" ] && [ "$sink_pid_check" = "$app_pid" ]; then
	    echo "$action $current_sink_num $param" 
        pactl "$action" "$current_sink_num" "$param" 
        fi
    fi
done
