#! /bin/bash

UNINSTALL_MODE=$1


# 强制卸载<普通卸载失败的时候>
if [ "${UNINSTALL_MODE}" == "--force" ]; then
    /userdata/H3C/Workspace/RUN/Device\ Redirect/uninstall_usb.sh
    
    rm /var/cache/apt/archives/lock
    dpkg -P --force-remove-reinstreq --admindir=/userdata/var/lib/dpkg workspace-vdi 
    dpkg -P --force-remove-reinstreq workspace-vdi 
    exit 0  
fi

# 在回滚的时候, 只卸载dpkg释放的文件
if [ "${UNINSTALL_MODE}" == "--rollback" ]; then
    /userdata/H3C/Workspace/RUN/Device\ Redirect/uninstall_usb.sh

    dpkg -r --force-remove-reinstreq --admindir=/userdata/var/lib/dpkg workspace-vdi
    dpkg -r --force-remove-reinstreq workspace-vdi 

    exit 0  
fi

# 静默安装时不需要二次用户确认， 否则需要用户确认才能继续卸载
CONFIRM_UNINSTALL="Y"
if [ "${UNINSTALL_MODE}" != "--silent" ]; then
    read -n1 -p "Do you want to continue [Y/N]?" answer
    case $answer in
        Y | y)
            echo "fine, continue"
            CONFIRM_UNINSTALL="Y";;
        N | n)
            echo "user canceled, good bye"
            CONFIRM_UNINSTALL="N";;
        *)
            echo "error choice"
            CONFIRM_UNINSTALL="N";;
    esac
fi

if [ "${CONFIRM_UNINSTALL}" == "N" ]; then
    exit 0
fi

/userdata/H3C/Workspace/RUN/Device\ Redirect/uninstall_usb.sh

# 如果是默认卸载, 那么就要卸载所有东西
dpkg -r --admindir=/userdata/var/lib/dpkg workspace-vdi
dpkg -r workspace-vdi
rm -f /userdata/H3C/Workspace/CURRENT
rm -f /userdata/H3C/Workspace/run.sh
rm -f /userdata/H3C/Workspace/run_vdsession.sh
rm -f /userdata/H3C/Workspace/run_iware.sh
rm -f /userdata/H3C/Workspace/workspace.conf.ini      
rm -f /usr/share/icons/Workspace.ico   
rm -f /usr/share/icons/small.ico  
rm -f /usr/share/icons/iware.ico
rm -rf /userdata/H3C/Workspace/RUN/Image

# 升级的时候是直接调用dpkg去卸载的。所以不会删除settings.ini
for x in $(who|awk -F ' ' '{print $1}')
do
   echo [INFO] who: $x
   if [ -f "/home/$x/文档/Workspace/settings.ini" ]; then
        echo [INFO] "Start to delete settings.ini of workspace"
        rm -f /home/$x/文档/Workspace/settings.ini
        rm -f /home/$x/文档/VdSession/*.vdp
   fi

   if [ -f "/home/$x/Documents/Workspace/settings.ini" ]; then
        echo [INFO] "Start to delete settings.ini of workspace"
        rm -f /home/$x/Documents/Workspace/settings.ini
        rm -f /home/$x/Documents/VdSession/*.vdp
   fi
done

# 防止卸载后使用dkpg -l还能查出来有残留
dpkg -P --force-remove-reinstreq --admindir=/userdata/var/lib/dpkg workspace-vdi
dpkg -P --force-remove-reinstreq workspace-vdi

