#! /bin/bash

isC100() {
    [ -e "/userdata/C100" ] && return 0 || return 1
}

fixC100Driver() {
    # get info from xrandr
    connectedOutputs=$(xrandr | grep " connected" | sed -e "s/\([A-Z0-9]\+\) connected.*/\1/")

    echo $connectedOutputs

    # initialize variables
    execute="xrandr"

    for display in $connectedOutputs
    do
        $execute --output $display --scale 0.9999x0.9999
    done
}

isUos() {
   CURRENTSYS=$(lsb_release -id |grep Distributor)
   if [[ $CURRENTSYS = *Uos* ]]
   then
       echo "is Uos: yes"
       return 0
   else
       echo "is Uos: no"
       return 1
   fi
}

writeKey() {
  file=$1;
  section=$2;
  key=$3;
  val=$4;
  awk -F "=" '/\['${section}'\]/{a=1} (a==1 && "'${key}'"==$1){gsub($2,"'${val}'");a=0} {print $0}' ${file} 1<>${file}
}

if isC100
then
    fixC100Driver
fi

if isUos
then
    COMPOSITOR_ACTIVE=$(qdbus org.kde.KWin /Compositor active)
    echo $COMPOSITOR_ACTIVE
    if [ $COMPOSITOR_ACTIVE = "false" ]
    then
        echo "set compositor enabled: true"
        writeKey ~/.config/kwinrc Compositing Enabled true
        qdbus org.kde.KWin /KWin reconfigure
        kwin --replace >/dev/null 2>/dev/null &
    fi
fi

/userdata/H3C/Workspace/RUN/start.sh $1
	
