#! /bin/bash

# 防止用户第一次安装不重启xhost +没有执行，因此在安装脚本中加一个命令xhost +
xhost +

# 脚本所在路径
current=$(cd "$(dirname "$0")"; pwd)

# -------------
# 安装debian包
# -------------
function installdebian {
    # 1 卸载老版本
    dpkg -P --force-remove-reinstreq --admindir=/userdata/var/lib/dpkg spaceagent
    dpkg -P --force-remove-reinstreq spaceagent

    if [[ -f /etc/spaceos-version ]]; then
        # 安装之前生成一些目录或文件, dpkg会使用这个目录
        if [ ! -d "/userdata/var/lib/dpkg" ]; then
            mkdir -p /userdata/var/lib/dpkg
        fi

        if [ ! -d "/userdata/var/lib/dpkg/updates" ]; then
            mkdir -p /userdata/var/lib/dpkg/updates
        fi

        if [ ! -d "/userdata/var/lib/dpkg/info" ]; then
            mkdir -p /userdata/var/lib/dpkg/info
        fi

        if [ ! -f "/userdata/var/lib/dpkg/status" ]; then
            touch /userdata/var/lib/dpkg/status
        fi

        dpkg -i --admindir=/userdata/var/lib/dpkg "$current/H3C_Workspace_SpaceAgent-E1016P02-linux-aarch64.deb"
    else
        dpkg -i "$current/H3C_Workspace_SpaceAgent-E1016P02-linux-aarch64.deb"
    fi
}

installdebian

